<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function cbio_styles() {
	if ( isset( $_GET['page'] ) ) {
		$page = sanitize_text_field( wp_unslash( $_GET['page'] ) );
		if ( $page === 'coding-bunny-image-optimizer' || $page === 'cbio-licence'|| $page === 'coding-bunny-image-watermark' ) {

			$css_file = plugin_dir_path( __FILE__ ) . '../assets/css/styles.css';
			if ( file_exists( $css_file ) ) {
				$version = filemtime( $css_file );
				wp_enqueue_style( 'coding-bunny-admin-styles', plugin_dir_url( __FILE__ ) . '../assets/css/styles.css', [], $version );
			}

			$js_file = plugin_dir_path( __FILE__ ) . '../assets/js/scripts.js';
			if ( file_exists( $js_file ) ) {
				$version = '1.0.0';
				wp_enqueue_script( 'coding-bunny-admin-script', plugin_dir_url( __FILE__ ) . '../assets/js/scripts.js', ['jquery'], $version, true );
			}
			
			$js_file = plugin_dir_path( __FILE__ ) . '../assets/js/watermark.js';
			if ( file_exists( $js_file ) ) {
				$version = '1.0.0';
				wp_enqueue_script( 'coding-bunny-watermark-script', plugin_dir_url( __FILE__ ) . '../assets/js/watermark.js', ['jquery'], $version, true );
			}
		}
	}
}
add_action( 'admin_enqueue_scripts', 'cbio_styles' );

function cbio_frontend_styles() {
	$disable_right_click = get_option('cbio_disable_right_click', '0');
	if ( '1' === $disable_right_click ) {
		$right_click_js_file = plugin_dir_path( __FILE__ ) . '../assets/js/right-click.js';
		if ( file_exists( $right_click_js_file ) ) {
			$version = '1.0.0';
			wp_enqueue_script( 'coding-bunny-right-click-script', plugin_dir_url( __FILE__ ) . '../assets/js/right-click.js', ['jquery'], $version, true );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'cbio_frontend_styles' );