<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

include_once plugin_dir_path(__DIR__) . '/includes/image-stats.php';
include_once plugin_dir_path(__DIR__) . '/includes/image-convert.php';
include_once plugin_dir_path(__DIR__) . '/includes/image-resize.php';
include_once plugin_dir_path(__DIR__) . '/includes/image-thumbnail.php';
include_once plugin_dir_path(__DIR__) . '/includes/toolbar.php';
include_once plugin_dir_path(__DIR__) . 'admin/licence-validation.php';

function cbio_settings_page() {
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}

	$licence_active = cbio_is_licence_valid_and_active();
	$disable_unused_images = $licence_active ? get_option('cbio_disable_unused_images', '0') : '0';
	$show_bulk_toolbar = $licence_active ? get_option('cbio_show_bulk_toolbar', '1') : '0';
	$disable_right_click = get_option('cbio_disable_right_click', '0');

	if ( isset( $_POST['submit'] ) ) {
		check_admin_referer( 'coding_bunny_image_settings_update' );

		$max_width = isset( $_POST['max_width'] ) ? absint( $_POST['max_width'] ) : 1000;
		$max_height = isset( $_POST['max_height'] ) ? absint( $_POST['max_height'] ) : 1000;
		$convert_format = isset( $_POST['convert_format'] ) ? sanitize_text_field( wp_unslash( $_POST['convert_format'] ) ) : 'webp';
		$enable_resize = isset( $_POST['enable_resize'] ) ? '1' : '0';
		$enable_conversion = isset( $_POST['enable_conversion'] ) ? '1' : '0';
		$quality_webp = isset( $_POST['quality_webp'] ) ? absint( $_POST['quality_webp'] ) : 80;
		$quality_avif = isset( $_POST['quality_avif'] ) ? absint( $_POST['quality_avif'] ) : 80;
		$enabled_image_sizes = isset( $_POST['enabled_image_sizes'] ) ? array_map( 'sanitize_text_field', wp_unslash( $_POST['enabled_image_sizes'] ) ) : [];
		$disable_unused_images = isset( $_POST['toggle_unused_images'] ) ? '1' : '0';
		$delete_original = isset( $_POST['delete_original'] ) ? '1' : '0';
		$disable_big_image_threshold = isset( $_POST['disable_big_image_threshold'] ) ? '1' : '0';
		$show_bulk_toolbar = isset( $_POST['show_bulk_toolbar'] ) ? '1' : '0';
		$disable_right_click = isset( $_POST['disable_right_click'] ) ? '1' : '0';
		$batch_size_selected = isset( $_POST['batch_size_selected'] ) ? absint( $_POST['batch_size_selected'] ) : 5;
		$batch_size_all = isset( $_POST['batch_size_all'] ) ? absint( $_POST['batch_size_all'] ) : 10;

		update_option( 'cbio_max_width', $max_width );
		update_option( 'cbio_max_height', $max_height );
		update_option( 'cbio_convert_format', $convert_format );
		update_option( 'cbio_enable_resize', $enable_resize );
		update_option( 'cbio_enable_conversion', $enable_conversion );
		update_option( 'cbio_enabled_image_sizes', $enabled_image_sizes );
		update_option( 'cbio_quality_webp', $quality_webp );
		update_option( 'cbio_quality_avif', $quality_avif );
		update_option( 'cbio_disable_unused_images', $disable_unused_images );
		update_option( 'cbio_delete_original', $delete_original );
		update_option( 'cbio_disable_big_image_threshold', $disable_big_image_threshold );
		update_option( 'cbio_show_bulk_toolbar', $show_bulk_toolbar );
		update_option( 'cbio_disable_right_click', $disable_right_click );
		update_option( 'cbio_batch_size', $batch_size_selected );
		update_option( 'cbio_batch_size_all', $batch_size_all );
	}

	$max_width = get_option( 'cbio_max_width', 1000 );
	$max_height = get_option( 'cbio_max_height', 1000 );
	$convert_format = get_option( 'cbio_convert_format', 'webp' );
	$enable_resize = get_option( 'cbio_enable_resize', '1' );
	$enable_conversion = get_option( 'cbio_enable_conversion', '1' );
	$enabled_image_sizes = get_option( 'cbio_enabled_image_sizes', array() );
	$intermediate_sizes = cbio_image_sizes();
	$using_gd = extension_loaded( 'gd' );
	$using_imagick = extension_loaded( 'imagick' );
	$gd_class = $using_gd ? 'cbio-enabled-lib' : 'cbio-disabled-lib';
	$imagick_class = $using_imagick ? 'cbio-enabled-lib' : 'cbio-disabled-lib';
	$image_stats = cbio_get_image_stats();
	$delete_original = get_option( 'cbio_delete_original', '1' );
	$disable_big_image_threshold = get_option( 'cbio_disable_big_image_threshold', '0' );	
	$batch_size_selected = $licence_active ? get_option('cbio_batch_size', '5') : '5';
	$batch_size_all = $licence_active ? get_option('cbio_batch_size_all', '10') : '10';

	if ( ! $licence_active ) {
		$enabled_image_sizes = array_keys( $intermediate_sizes );
	}

	?>

	<div class="wrap">
		<h1><?php esc_html_e( 'CodingBunny Image Optimizer PRO', 'coding-bunny-image-optimizer' ); ?> 
			<span>v<?php echo esc_html( CBIO_VERSION ); ?></span></h1>
			<form method="post" action="">
				<?php wp_nonce_field( 'coding_bunny_image_settings_update' ); ?>
				<div class="cbio-content">
					<div class="cbio-section">
						<div class="cbio-header-section">
							<h3><?php esc_html_e( 'Automatic Conversion', 'coding-bunny-image-optimizer' ); ?></h3>
							<p>
								<?php esc_html_e( 'When you upload images to the site, they are automatically converted to WebP or AVIF.', 'coding-bunny-image-optimizer' ); ?>
							</p>
						</div>
						<table class="cbio-form-table">
							<tr valign="top">
								<th scope="row"><label for="enable_conversion"><?php esc_html_e( 'Enable Conversion', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<label class="cbio-toggle-label">
										<input type="checkbox" class="cbio-toggle" id="enable_conversion" name="enable_conversion" value="1" <?php checked( $enable_conversion, '1' ); ?> />
										<span class="cbio-slider"></span>
										<?php esc_html_e( 'Convert images to the selected format.', 'coding-bunny-image-optimizer' ); ?>
									</label>
									<p class="cbio-notes"><?php esc_html_e('Set the conversion format between WebP and AVIF. Only JPEG, PNG, GIF or HEIC images will be converted.', 'coding-bunny-image-optimizer'); ?></p>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row"><label for="convert_format"><?php esc_html_e( 'Conversion Format', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<div class="cbio-radio-button-wrapper">
										<input type="radio" id="convert_format_webp" name="convert_format" value="webp" <?php checked( $convert_format, 'webp' ); ?> />
										<label for="convert_format_webp" class="cbio-radio-label"><?php esc_html_e( 'WebP', 'coding-bunny-image-optimizer' ); ?></label>
									</div>
									<div class="cbio-radio-button-wrapper">
										<input type="radio" id="convert_format_avif" name="convert_format" value="avif" <?php checked( $convert_format, 'avif' ); ?> <?php echo ( ! $licence_active ) ? 'disabled' : ''; ?> />
										<label for="convert_format_avif" class="cbio-radio-label"><?php esc_html_e( 'AVIF', 'coding-bunny-image-optimizer' ); ?></label>
									</div>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row"><label for="quality_webp"><?php esc_html_e( 'WEBP Quality', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<?php $quality_webp = get_option('cbio_quality_webp', 80); ?>
									<input type="radio" id="quality_webp_lossy" name="quality_webp_preset" value="60" class="cbio-quality-checkbox" <?php checked( $quality_webp, 60 ); ?> <?php echo ( ! $licence_active ) ? 'disabled' : ''; ?>>
									<label for="quality_webp_lossy" class="cbio-radio-label"><?php esc_html_e( 'Lossy', 'coding-bunny-image-optimizer' ); ?></label>

									<input type="radio" id="quality_webp_glossy" name="quality_webp_preset" value="80" class="cbio-quality-checkbox" <?php checked( $quality_webp, 80 ); ?> <?php echo ( ! $licence_active ) ? 'disabled' : ''; ?>>
									<label for="quality_webp_glossy" class="cbio-radio-label"><?php esc_html_e( 'Glossy', 'coding-bunny-image-optimizer' ); ?></label>

									<input type="radio" id="quality_webp_lossless" name="quality_webp_preset" value="100" class="cbio-quality-checkbox" <?php checked( $quality_webp, 100 ); ?> <?php echo ( ! $licence_active ) ? 'disabled' : ''; ?>>
									<label for="quality_webp_lossless" class="cbio-radio-label"><?php esc_html_e( 'Lossless', 'coding-bunny-image-optimizer' ); ?></label>

									<input type="range" id="quality_webp" name="quality_webp" min="10" max="100" 
									value="<?php echo esc_attr( $quality_webp ); ?>" 
									<?php echo ( ! $licence_active ) ? 'disabled' : ''; ?> 
									oninput="this.nextElementSibling.value = this.value">
									<output class="cbio-check-label <?php echo ( ! $licence_active ) ? 'cbio-disabled-label' : ''; ?>"><?php echo esc_attr( $quality_webp ); ?></output>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row"><label for="quality_avif"><?php esc_html_e( 'AVIF Quality', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<?php $quality_avif = get_option('cbio_quality_avif', 80); ?>
									<input type="radio" id="quality_avif_lossy" name="quality_avif_preset" value="60" class="cbio-quality-checkbox" <?php checked( $quality_avif, 60 ); ?> <?php echo ( ! $licence_active ) ? 'disabled' : ''; ?>>
									<label for="quality_avif_lossy" class="cbio-radio-label"><?php esc_html_e( 'Lossy', 'coding-bunny-image-optimizer' ); ?></label>

									<input type="radio" id="quality_avif_glossy" name="quality_avif_preset" value="80" class="cbio-quality-checkbox" <?php checked( $quality_avif, 80 ); ?> <?php echo ( ! $licence_active ) ? 'disabled' : ''; ?>>
									<label for="quality_avif_glossy" class="cbio-radio-label"><?php esc_html_e( 'Glossy', 'coding-bunny-image-optimizer' ); ?></label>

									<input type="radio" id="quality_avif_lossless" name="quality_avif_preset" value="100" class="cbio-quality-checkbox" <?php checked( $quality_avif, 100 ); ?> <?php echo ( ! $licence_active ) ? 'disabled' : ''; ?>>
									<label for="quality_avif_lossless" class="cbio-radio-label"><?php esc_html_e( 'Lossless', 'coding-bunny-image-optimizer' ); ?></label>

									<input type="range" id="quality_avif" name="quality_avif" min="10" max="100" 
									value="<?php echo esc_attr( $quality_avif ); ?>" 
									<?php echo ( ! $licence_active ) ? 'disabled' : ''; ?> 
									oninput="this.nextElementSibling.value = this.value">
									<output class="cbio-check-label <?php echo ( ! $licence_active ) ? 'cbio-disabled-label' : ''; ?>"><?php echo esc_attr( $quality_avif ); ?></output>
									<p class="cbio--notes"><?php esc_html_e('Export quality in AVIF format is available only when using the Imagick PHP module.', 'coding-bunny-image-optimizer'); ?></p>
								</td>							
							</tr>
							<tr valign="top">
								<th scope="row"><label for="delete_original"><?php esc_html_e('Delete Original Images', 'coding-bunny-image-optimizer'); ?></label></th>
								<td>
									<label class="cbio-toggle-label">
										<input type="checkbox" class="cbio-toggle" id="delete_original" name="delete_original" value="1" <?php checked( $delete_original, '1' ); ?> />
										<span class="cbio-slider"></span>
										<?php esc_html_e('Delete the original images after conversion.', 'coding-bunny-image-optimizer'); ?>
									</label>
									<p class="cbio-notes"><?php esc_html_e('Disable this option to keep a copy of the original images so that you can restore them at any time. Note: Keeping a copy of the original images can significantly increase the size of the uploads folder.', 'coding-bunny-image-optimizer'); ?></p>
								</td>
							</tr>
						</table>						
						<?php submit_button(esc_html__('Save Settings', 'coding-bunny-image-optimizer')); ?>
					</div>
					<div class="cbio-section">
						<h3><?php esc_html_e( 'Automatic Resizing', 'coding-bunny-image-optimizer' ); ?></h3>
						<p>
							<?php esc_html_e( 'When you upload images to your site, they will be resized automatically.', 'coding-bunny-image-optimizer' ); ?>
						</p>
						<table class="cbio-form-table">
							<tr valign="top">
								<th scope="row"><label for="enable_resize"><?php esc_html_e( 'Enable Resizing', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<label class="cbio-toggle-label">
										<input type="checkbox" class="cbio-toggle" id="enable_resize" name="enable_resize" value="1" <?php checked( $enable_resize, '1' ); ?> />
										<span class="cbio-slider"></span>
										<?php esc_html_e( 'Resizes images to the size below.', 'coding-bunny-image-optimizer' ); ?>
									</label>
									<p class="cbio-notes"><?php esc_html_e('Set maximum dimensions for height and width of your images.', 'coding-bunny-image-optimizer'); ?></p>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row"><label for="max_width"><?php esc_html_e( 'Max. width (px)', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td><input type="number" id="max_width" name="max_width" value="<?php echo esc_attr( $max_width ); ?>" min="0" /></td>							
							</tr>
							<tr valign="top">
								<th scope="row"><label for="max_height"><?php esc_html_e( 'Max. height (px)', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td><input type="number" id="max_height" name="max_height" value="<?php echo esc_attr( $max_height ); ?>" min="0" /></td>
							</tr>
							<tr valign="top">
								<th scope="row"><label for="disable_big_image_threshold"><?php esc_html_e('Big Image Threshold', 'coding-bunny-image-optimizer'); ?></label></th>
								<td>
									<label class="cbio-toggle-label">
										<input type="checkbox" class="cbio-toggle" id="disable_big_image_threshold" name="disable_big_image_threshold" value="1" <?php checked($disable_big_image_threshold, '1'); ?> />
										<span class="cbio-slider"></span>
										<?php esc_html_e('Disable default big image threshold.', 'coding-bunny-image-optimizer'); ?>
									</label>
									<p class="cbio-notes"><?php esc_html_e('As of WordPress 5.3, large uploaded images are resized to a maximum width and height of 2560px. If larger images are desired, enable this setting.', 'coding-bunny-image-optimizer'); ?></p>
								</td>
							</tr>
						</table>					
						<?php submit_button(esc_html__('Save Settings', 'coding-bunny-image-optimizer')); ?>
					</div>
					<div class="cbio-section">
						<h3><?php esc_html_e( 'Default Image Sizes', 'coding-bunny-image-optimizer' ); ?></h3>
						<p>
							<?php esc_html_e( 'WordPress generates multiple thumbnails for each uploaded image. Choose which of these thumbnails you want to include when the images are optimized.', 'coding-bunny-image-optimizer' ); ?>
						</p>
						<table class="cbio-form-table">
							<tr valign="top">
								<th scope="row"><?php esc_html_e( 'Image size', 'coding-bunny-image-optimizer' ); ?></th>
								<td>
									<?php

									foreach ( $intermediate_sizes as $size => $data ) {
										$width = isset( $data['width'] ) ? $data['width'] : '';
										$height = isset( $data['height'] ) ? $data['height'] : '';

										$checked = ( ! $licence_active ) ? 'checked' : checked( in_array( $size, $enabled_image_sizes, true ), true, false );
										?>
										<label class="cbio-toggle-label <?php echo ( ! $licence_active ) ? 'cbio-disabled-label' : ''; ?>">
											<input type="checkbox" name="enabled_image_sizes[]" value="<?php echo esc_attr( $size ); ?>" <?php checked( in_array( $size, $enabled_image_sizes, true ), true ); ?> class="cbio-toggle" <?php echo ( ! $licence_active ) ? 'disabled' : ''; ?> />
											<span class="cbio-slider"></span>
											<span class="cbio-toggle-label"><?php echo esc_html( $size ); ?> (<?php echo esc_html( $width . ' x ' . $height . ' px' ); ?>)</span>
										</label>
										<br>
										<?php
									}
									?>
								</td>
							</tr>
						</table>
						<?php submit_button(esc_html__('Save Settings', 'coding-bunny-image-optimizer')); ?>
					</div>
					<div class="cbio-section">
						<h3><?php esc_html_e( 'More Options', 'coding-bunny-image-optimizer' ); ?></h3>
						<p>
							<?php esc_html_e( 'Enable more options.', 'coding-bunny-image-optimizer' ); ?>
						</p>
						<table class="cbio-form-table">
							<tr valign="top">
								<th scope="row"><label for="show_bulk_toolbar"><?php esc_html_e( 'Bulk Image Optimization', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<label class="cbio-toggle-label <?php echo ( ! $licence_active ) ? 'cb-disabled-label' : ''; ?>">
										<input type="checkbox" class="cbio-toggle" id="show_bulk_toolbar" name="show_bulk_toolbar" value="1" <?php checked( $show_bulk_toolbar, '1' ); ?><?php echo ( ! $licence_active ) ? 'disabled' : ''; ?> />
										<span class="cbio-slider"></span>
										<?php esc_html_e( 'Enables the BIO toolbar in the media library.', 'coding-bunny-image-optimizer' ); ?>
									</label>
									<p class="cbio-notes"><?php esc_html_e('This option allows you to simultaneously optimize all or several selected images in the library.', 'coding-bunny-image-optimizer'); ?></p>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row"><label for="batch_size_selected"><?php esc_html_e( 'Selected Images Batch', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<div class="cbio-field-group">
										<input type="range" id="batch_size_selected" name="batch_size_selected" min="1" max="100" step="1"
										value="<?php echo esc_attr( $batch_size_selected ); ?>"
										<?php echo ( ! $licence_active ) ? 'disabled' : ''; ?>
										oninput="this.nextElementSibling.value = this.value">
										<output class="cbio-check-label <?php echo ( ! $licence_active ) ? 'cbio-disabled-label' : ''; ?>"><?php echo esc_attr( $batch_size_selected ); ?></output>
										<p class="cbio-notes"><?php esc_html_e('Number of images to process at once when optimizing selected images. Lower values are safer but slower, higher values are faster but may cause timeouts on limited hosting.', 'coding-bunny-image-optimizer'); ?></p>
									</div>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row"><label for="batch_size_selected"><?php esc_html_e( 'All Images Batch', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<div class="cbio-field-group">
										<input type="range" id="batch_size_all" name="batch_size_all" min="1" max="100" step="1"
										value="<?php echo esc_attr( $batch_size_all ); ?>"
										<?php echo ( ! $licence_active ) ? 'disabled' : ''; ?>
										oninput="this.nextElementSibling.value = this.value">
										<output class="cbio-check-label <?php echo ( ! $licence_active ) ? 'cbio-disabled-label' : ''; ?>"><?php echo esc_attr( $batch_size_all ); ?></output>
										<p class="cbio-notes"><?php esc_html_e('Number of images to process at once when optimizing all images. Lower values are safer but slower, higher values are faster but may cause timeouts on limited hosting.', 'coding-bunny-image-optimizer'); ?></p>
									</div>
								</td>
							</tr>							
							<tr><td><br></td></tr>
							<tr valign="top">
								<th scope="row"><label for="disable_right_click"><?php esc_html_e( 'Image Protection', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<label class="cbio-toggle-label">
										<input type="checkbox" class="cbio-toggle" id="disable_right_click" name="disable_right_click" value="1" <?php checked( $disable_right_click, '1' ); ?> />
										<span class="cbio-slider"></span>
										<?php esc_html_e( 'Disable right-click context menu on images.', 'coding-bunny-image-optimizer' ); ?>
									</label>
									<p class="cbio-notes"><?php esc_html_e('This option prevents context menu (right-click) and dragging images onto the page.', 'coding-bunny-image-optimizer'); ?></p>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row"><label for="watermark"><?php esc_html_e( 'Watermark', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<a href="<?php echo esc_url( admin_url( 'admin.php?page=coding-bunny-image-watermark' ) ); ?>" class="button" <?php echo ( ! $licence_active ) ? 'disabled' : ''; ?>><?php esc_html_e( 'Go to Watermark Settings', 'coding-bunny-image-optimizer' ); ?></a>
								</td>
							</tr>
							<tr><td><br></td></tr>							
							<tr valign="top">
								<th scope="row"><label for="toggle-unused-images"><?php esc_html_e( 'Unused Images Finder', 'coding-bunny-image-optimizer' ); ?></label></th>
								<td>
									<label class="cbio-toggle-label <?php echo ( ! $licence_active ) ? 'cb-disabled-label' : ''; ?>">
										<input type="checkbox" class="cbio-toggle" id="toggle-unused-images" name="toggle_unused_images" value="1" <?php checked( $disable_unused_images, '1' ); ?><?php echo ( ! $licence_active ) ? 'disabled' : ''; ?> />
										<span class="cbio-slider"></span>
										<?php esc_html_e( 'Enables the UIF toolbar in the media library.', 'coding-bunny-image-optimizer' ); ?>
									</label>
									<p class="cbio-notes"><?php esc_html_e('This option identifies unused images within the site. Before proceeding with their deletion, it is advisable to make a full backup and carefully check the accuracy of the result.', 'coding-bunny-image-optimizer'); ?></p>
								</td>
							</tr>
						</table>
						<?php submit_button(esc_html__('Save Settings', 'coding-bunny-image-optimizer')); ?>
					</div>		
					<div class="cbio-section">
						<h3><?php esc_html_e('System Info', 'coding-bunny-image-optimizer'); ?></h3>
						<p><?php esc_html_e('Shows installed PHP modules and statistics on library images.', 'coding-bunny-image-optimizer'); ?></p>
						<table class="cbio-form-table">
							<tr valign="top">
								<th scope="row"><label for="php-modules"><?php esc_html_e('PHP Modules:', 'coding-bunny-image-optimizer'); ?></label></th>
								<td>
									<span class="cbio-php-module-label <?php echo esc_attr($gd_class); ?>">GD</span>
									<span class="cbio-php-module-label <?php echo esc_attr($imagick_class); ?>">Imagick</span>
								</td>
							</tr>
						</table>
						<table class="cbio-form-table">
							<tr valign="top">
								<th scope="row"><?php esc_html_e('Images Optimized:', 'coding-bunny-image-optimizer'); ?></th>
								<td><?php echo esc_html(number_format($image_stats['optimized_percentage'], 2)); ?>%</td>
								<th scope="row"><?php esc_html_e('Total Images:', 'coding-bunny-image-optimizer'); ?></th>
								<td><?php echo esc_html($image_stats['total_count']); ?></td>
								<th scope="row"><?php esc_html_e('Total Size:', 'coding-bunny-image-optimizer'); ?></th>
								<td><?php echo esc_html(number_format($image_stats['total_size'], 2)); ?> MB</td>
							</tr>
							<tr valign="top">
								<th scope="row"><?php esc_html_e('JPEG Images:', 'coding-bunny-image-optimizer'); ?></th>
								<td><?php echo esc_html($image_stats['image_counts']['jpeg']); ?></td>
								<th scope="row"><?php esc_html_e('PNG Images:', 'coding-bunny-image-optimizer'); ?></th>
								<td><?php echo esc_html($image_stats['image_counts']['png']); ?></td>
								<th scope="row"><?php esc_html_e('GIF Images:', 'coding-bunny-image-optimizer'); ?></th>
								<td><?php echo esc_html($image_stats['image_counts']['gif']); ?></td>
							</tr>
							<tr valign="top">
								<th scope="row"><?php esc_html_e('SVG Images:', 'coding-bunny-image-optimizer'); ?></th>
								<td><?php echo esc_html($image_stats['image_counts']['svg']); ?></td>
								<th scope="row"><?php esc_html_e('WEBP Images:', 'coding-bunny-image-optimizer'); ?></th>
								<td><?php echo esc_html($image_stats['image_counts']['webp']); ?></td>
								<th scope="row"><?php esc_html_e('AVIF Images:', 'coding-bunny-image-optimizer'); ?></th>
								<td><?php echo esc_html($image_stats['image_counts']['avif']); ?></td>
							</tr>
						</table>
						<p>
							<a href="<?php echo esc_url(admin_url('upload.php')); ?>" class="button"><?php esc_html_e('Go to Media Library', 'coding-bunny-image-optimizer'); ?></a>
						</p>	
					</div>
				</div>
			</form>
			<p>
				© <?php echo esc_html(gmdate('Y')); ?> - 
				<?php esc_html_e('Powered by CodingBunny', 'coding-bunny-image-optimizer'); ?> |
				<a href="https://coding-bunny.com/support/" target="_blank" rel="noopener"><?php esc_html_e('Support', 'coding-bunny-image-optimizer'); ?></a> |
				<a href="https://coding-bunny.com/documentation/image-optimizer-doc/" target="_blank" rel="noopener"><?php esc_html_e('Documentation', 'coding-bunny-image-optimizer'); ?></a> |
				<a href="https://coding-bunny.com/changelog/" target="_blank" rel="noopener"><?php esc_html_e('Changelog', 'coding-bunny-image-optimizer'); ?></a>
			</p>
		</div>
		<?php
	}