<?php

/**
 * Plugin Name: CodingBunny Image Optimizer PRO
 * Plugin URI:  https://coding-bunny.com/image-optimizer/
 * Description: Speed up your site! Compress and optimize images automatically.
 * Version:     1.5.3
 * Requires at least: 6.0
 * Requires PHP: 8.0
 * Author:      CodingBunny
 * Author URI:  https://coding-bunny.com
 * Text Domain: coding-bunny-image-optimizer
 * Domain Path: /languages
 * License: GPLv2 or later
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'CBIO_VERSION', '1.5.3' );
define( 'CBIO_PLUGIN_FILE', __FILE__ );

class CodingBunnyImageOptimizer {

    private $admin_dir;
    private $includes_dir;
    private $updater_dir;

    public function __construct() {
        $this->admin_dir = plugin_dir_path( __FILE__ ) . 'admin/';
        $this->includes_dir = plugin_dir_path( __FILE__ ) . 'includes/';
        $this->updater_dir = plugin_dir_path( __FILE__ ) . 'updater/';
        $this->load_dependencies();
        $this->register_hooks();
    }

    private function load_dependencies() {
        $image_stats_file = $this->includes_dir . 'image-stats.php';
        if ( file_exists( $image_stats_file ) ) {
            require_once $image_stats_file;
        } else {
            error_log( "File not found: $image_stats_file" );
        }

        $files_to_include = [
            'admin-menu.php',
            'licence-validation.php',
            'settings-page.php',
            'bulk-edit.php',
            'unused-image.php',
            'image-watermark.php',
            'enqueue-scripts.php',
        ];

        foreach ( $files_to_include as $file ) {
            $file_path = $this->admin_dir . $file;
            if ( file_exists( $file_path ) ) {
                require_once $file_path;
            } else {
                error_log( "File not found: $file_path" );
            }
        }

        $updates_check_file = $this->updater_dir . 'updates-check.php';
        if ( file_exists( $updates_check_file ) ) {
            require_once $updates_check_file;
        } else {
            error_log( "File not found: $updates_check_file" );
        }
    }

    private function register_hooks() {
        add_action( 'plugins_loaded', [ $this, 'load_textdomain' ] );
        add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), [ $this, 'add_action_links' ] );
    }

    public function load_textdomain() {
        load_plugin_textdomain( 'coding-bunny-image-optimizer', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
    }

    public function add_action_links( $links ) {
        if ( is_array( $links ) ) {
            $settings_link = '<a href="' . esc_url( admin_url( 'admin.php?page=coding-bunny-image-optimizer' ) ) . '">' . esc_html__( 'Settings', 'coding-bunny-image-optimizer' ) . '</a>';
            array_unshift( $links, $settings_link );
        }
        return $links;
    }
}

$coding_bunny_image_optimizer = new CodingBunnyImageOptimizer();