<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Function to convert images to WEBP
function cbio_convert_images($file_path, $output_path, $format) {
    if (extension_loaded('imagick')) {
        $image = new Imagick($file_path);
        if ($format === 'webp') {
            $image->setImageFormat('webp');
        }
        $image->writeImage($output_path);
        $image->clear();
        $image->destroy();
        return true;
    } elseif (extension_loaded('gd')) {
        $image = imagecreatefromstring(file_get_contents($file_path));
        if ($format === 'webp') {
            imagewebp($image, $output_path);
        }
        imagedestroy($image);
        return true;
    }
    return false;
}

// Convert images to WEBP or AVIF format on upload
function cbio_convert_image($upload) {
    $enable_conversion = get_option('cbio_enable_conversion', '1');
    if ($enable_conversion !== '1') {
        return $upload;
    }

    $convert_format = get_option('cbio_convert_format', 'webp');
    $delete_original = get_option('cbio_delete_original', '0');

    if ($convert_format && isset($upload['type']) && in_array($upload['type'], ['image/jpeg', 'image/png', 'image/gif', 'image/heic'])) {
        $file_path = $upload['file'];

        if (extension_loaded('imagick') || extension_loaded('gd')) {
            $output_path = pathinfo($file_path, PATHINFO_DIRNAME) . '/' . pathinfo($file_path, PATHINFO_FILENAME) . '.' . $convert_format;

            if (convert_image($file_path, $output_path, $convert_format)) {
                $upload['file'] = $output_path;
                $upload['url'] = str_replace(basename($upload['url']), basename($output_path), $upload['url']);
                $upload['type'] = 'image/' . $convert_format;

                if ($delete_original === '1') {
                    wp_delete_file($file_path);
                }

                if (get_option('cbio_disable_big_image_threshold', '0') === '1') {
                    add_filter('big_image_size_threshold', '__return_false');
                }
            }
        }
    }
    return $upload;
}
add_filter('wp_handle_upload', 'cbio_convert_image');

?>