<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function cbio_disable_intermediate_image_sizes($sizes) {
    $licence_active = cbio_is_licence_valid_and_active();

    if ( ! $licence_active ) {
        return $sizes;
    }

    $enabled_image_sizes = get_option('cbio_enabled_image_sizes', array());
    if (empty($enabled_image_sizes)) {
        return array();
    }

    foreach ($sizes as $size => $data) {
        if ( ! in_array($size, $enabled_image_sizes)) {
            unset($sizes[$size]);
        }
    }
    return $sizes;
}
add_filter('intermediate_image_sizes_advanced', 'cbio_disable_intermediate_image_sizes');

function cbio_image_sizes() {
    $sizes = [];
    $image_sizes = get_intermediate_image_sizes();

    foreach ( $image_sizes as $size ) {
        $data = wp_get_additional_image_sizes();
        if ( isset( $data[ $size ] ) ) {
            $sizes[ $size ] = $data[ $size ];
        } else {
            $sizes[ $size ] = [
                'width' => get_option( $size . '_size_w' ),
                'height' => get_option( $size . '_size_h' ),
            ];
        }
    }
    return $sizes;
}