<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// UIF Toolbar
function cbio_toggle_unused_images() {
    if ( isset( $_POST['toggle_unused_images'] ) ) {
        $toggle_unused_images = wp_unslash( $_POST['toggle_unused_images'] );
        $disable_unused_images = sanitize_text_field( $toggle_unused_images ) === '1' ? '1' : '0';
        update_option( 'cbio_disable_unused_images', $disable_unused_images );
    }
    return get_option( 'cbio_disable_unused_images', '0' );
}
add_action( 'admin_post_toggle_unused_images', 'cbio_toggle_unused_images' );


// BIO Toolbar
function cbio_should_show_bulk_toolbar() {
    $licence_active = cbio_is_licence_valid_and_active();
    return $licence_active && get_option('cbio_show_bulk_toolbar', '1') === '1';
}