<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once plugin_dir_path(__FILE__) . 'version.php';

function cbio_plugin_update_info($transient) {
    if (empty($transient->checked)) {
        return $transient;
    }

    $current_version = defined('CBIO_VERSION') ? sanitize_text_field(CBIO_VERSION) : '1.5.2';
    $url = esc_url_raw('https://coding-bunny.com/plugins-updates/io-check-version.php');

    $response = wp_remote_post($url, [
        'body' => [
            'version' => $current_version,
        ],
        'timeout' => 15,
        'sslverify' => true,
    ]);

    if (is_wp_error($response)) {
        return $transient;
    }

    $body = wp_remote_retrieve_body($response);
    $decoded_body = json_decode($body, true);

    if (is_array($decoded_body) && isset($decoded_body['update_available']) && $decoded_body['update_available']) {
        $transient->response['coding-bunny-image-optimizer/coding-bunny-image-optimizer.php'] = (object) [
            'slug'        => 'coding-bunny-image-optimizer',
            'new_version' => sanitize_text_field($decoded_body['latest_version']),
            'package'     => esc_url_raw('https://coding-bunny.com/plugins-updates/coding-bunny-image-optimizer.zip'),
            'url'         => esc_url_raw('https://coding-bunny.com/image-optimizer/'),
        ];
    }

    return $transient;
}
add_filter('site_transient_update_plugins', 'cbio_plugin_update_info');