<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function cbio_plugin_update_icon($response, $action, $args) {
	if ($action === 'plugin_information' && isset($args->slug) && $args->slug === 'coding-bunny-image-optimizer') {
		$plugin_version = defined( 'CBIO_VERSION' ) ? sanitize_text_field( CBEC_VERSION ) : '1.5.3';
		$response = (object) [
			'name'        => 'Coding Bunny Image Optimizer PRO',
			'slug'        => 'coding-bunny-image-optimizer',
			'version'     => $plugin_version,
			'author'      => '<a href="https://coding-bunny.com">Coding Bunny</a>',
			'homepage'    => esc_url_raw('https://coding-bunny.com/image-optimizer/'),
			'requires'    => '6.0',
			'tested'      => '6.8',
			'requires_php'=> '8.0',
			'sections'    => [
			'changelog' => wp_kses_post('

			<h4>1.5.3: 2025-04-17</h4>
			<ul>
			<li><strong>Fix:</strong> Fixed problem with saving settings.</li>
			</ul>
				
			<h4>1.5.2: 2025-04-16</h4>
			<ul>
			<li><strong>Improvement:</strong> Added support for automatic updates (PRO version).</li>
			</ul>

			<h4>1.5.1: 2025-04-04</h4>
			<ul>
			<li><strong>Fix:</strong> Fixed error with thumbnail creation (PRO version).</li>
			</ul>

			<h4>1.5.0: 2025-04-04</h4>
			<ul>
			<li><strong>New:</strong> Added options to disable right-click on images.</li>
			<li><strong>New:</strong> Added functionality to apply custom watermarks to images (PRO).</li>
			<li><strong>New:</strong> Added Bulk image batch selection. You can now choose how many images the server can process at one time based on the performance of your server (PRO).</li>
			<li><strong>Improvement:</strong> Improved code for performance.</li>
			<li><strong>Improvement:</strong> Changed license management system (PRO).</li>
			</ul>

			<h4>1.4.5: 2025-03-17</h4>
			<ul>
			<li><strong>Fix:</strong> Fixed error that caused the Unused Images Finder function not to work with some configurations (PRO version).</li>
			</ul>

			<h4>1.4.4: 2025-02-20</h4>
			<ul>
			<li><strong>New:</strong> Added support for converting HEIC image format (Requires WordPress 6.7 and ImageMagick 7 or above).</li>
			</ul>

			<h4>1.4.3: 2025-02-09</h4>
			<ul>
			<li><strong>Improvement:</strong> Improve code.</li>
			</ul>

			<h4>1.4.2: 2025-01-17</h4>
			<ul>
			<li><strong>Fix:</strong> The “Image Stats” widget has been removed because it was slowing down the loading of the WordPress dashboard on some servers.</li>
			<li><strong>Fix:</strong> Minor bug fix.</li>
			</ul>

			<h4>1.4.1: 2025-01-15</h4>
			<ul>
			<li><strong>Fix:</strong> Fixed PHP errors generated in rare cases from images already in the archive.</li>
			</ul>

			<h4>1.4.0: 2025-01-06</h4>
			<ul>
			<li><strong>New:</strong> Added new feature “Unused Images Finder” beta version.</li>
			<li><strong>New:</strong> Added new feature “Big Image Threshold”.</li>
			<li><strong>New:</strong> Added quality conversion presets (PRO version).</li>
			<li><strong>New:</strong> Added new option to enable/disable “Unused Images Finder” toolbar (PRO version).</li>
			<li><strong>New:</strong> Added new option to enable/disable “Bulk Image Optimizer” toolbar (PRO version).</li>
			<li><strong>New:</strong> Added “Images Stats” widget in the WordPress dashboard.</li>
			<li><strong>New:</strong> Added “System Info” panel.</li>
			<li><strong>Improvement:</strong> Added French, German and Spanish language support (PRO version).</li>
			<li><strong>Improvement:</strong> New feature “Unused Images Finder” is now in final version (PRO version).</li>
			<li><strong>Improvement:</strong> Improve code security and performance.</li>
			<li><strong>Improvement:</strong> Modified user interface.</li>
			<li><strong>Improvement:</strong> Compatibility with PHP 8.4</li>
			<li><strong>Fix:</strong> Removed the progress bar from the “Bulk Image Optimizer” toolbar because it was slowing down the optimization process on some servers (PRO version).</li>
			</ul>

			<h4>1.3.0: 2024-12-11</h4>
			<ul>
			<li><strong>New:</strong> Added new feature “Unused Images Finder” beta version (PRO version).</li>
			</ul>

			<h4>1.2.3: 2024-11-30</h4>
			<ul>
			<li><strong>Improvement:</strong> Added Thai language support (PRO version).</li>
			<li><strong>Improvement:</strong> General code improvement.</li>
			<li><strong>Fix:</strong> Fixed Bulk Resize translation problem (PRO version).</li>
			</ul>

			<h4>1.2.2: 2024-11-13</h4>
			<ul>
			<li><strong>Fix:</strong> Fixed the error that allowed images to be enlarged with Imagick.</li>
			</ul>

			<h4>1.2.1: 2024-11-11</h4>
			<ul>
			<li><strong>New:</strong> Added conversion status bar (PRO version).</li>
			<li><strong>Improvement:</strong> General code safety improvement.</li>
			</ul>

			<h4>1.2.0: 2024-11-08</h4>
			<ul>
			<li><strong>New:</strong> Added conversion quality setting (PRO version).</li>
			<li><strong>New:</strong> Added button to convert all library images without selecting them (PRO version).</li>
			<li><strong>Improvement:</strong> Intermediate sizes of images in library are now removed after conversion (PRO version).</li>
			<li><strong>Fix:</strong> During bulk optimization, images were being resized even with the option turned off (PRO version).</li>
			</ul>

			<h4>1.1.0: 2024-01-30</h4>
			<ul>
			<li><strong>New:</strong> Added bulk optimization of images in library (PRO version).</li>
			<li><strong>Improvement:</strong> Changed interface style.</li>
			</ul>

			<h4>1.0.0: 2024-10-18</h4>
			<ul>
			<li><strong>New:</strong> Initial Release.</li>
			</ul>
			'),			
		],
		'banners'       => [
		'low'  => esc_url_raw( plugins_url( '../updater/assets/banner-772x250.png', __FILE__ ) ),
		'high' => esc_url_raw( plugins_url( '../updater/assets/banner-1544x500.png', __FILE__ ) ),
	],
	'download_link' => esc_url_raw('https://coding-bunny.com/plugins-updates/coding-bunny-image-optimizer.zip'),
];
}
return $response;
}
add_filter('plugins_api', 'cbio_plugin_update_icon', 10, 3);